---
Difficulty: Medium  
Source: Daily-Question (POTD 13-Dec)  
Tags:  
- Heap (Priority Queue)
- Sorting
- Array
- Simulation
- Hash Table
- Ordered Set
- Ordered Map
- Greedy
- Queue
- Data Stream
- Tree
- Divide and Conquer
- String
- Design
- Dynamic Programming
- Hash Function
- Doubly-Linked List
- Bit Manipulation
- Stack
- Two Pointers
- Sliding Window
---

# 🚀 *2593 - Find Score of an Array After Marking All Elements* 🧠

### Problem Link:
[**LeetCode - Find Score of an Array After Marking All Elements**](https://leetcode.com/problems/find-score-of-an-array-after-marking-all-elements/description/?envType=daily-question&envId=2024-12-13)

## 💡 **Problem Breakdown:**

You are given an array `nums` consisting of positive integers.

Starting with `score = 0`, apply the following algorithm:

1. Choose the smallest integer of the array that is not marked. If there is a tie, choose the one with the smallest index.
2. Add the value of the chosen integer to the score.
3. Mark the chosen element and its two adjacent elements if they exist.
4. Repeat until all the array elements are marked.

Return the score you get after applying the above algorithm.

## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`nums = [2,1,3,4,5,2]`

**Output:**  
`7`

**Explanation:**  
We mark the elements as follows:
- 1 is the smallest unmarked element, so we mark it and its two adjacent elements: [2,1,3,4,5,2].
- 2 is the smallest unmarked element, so we mark it and its left adjacent element: [2,1,3,4,5,2].
- 4 is the only remaining unmarked element, so we mark it: [2,1,3,4,5,2].

Our score is 1 + 2 + 4 = **7**.

### Example 2:

**Input:**  
`nums = [2,3,5,1,3,2]`

**Output:**  
`5`

**Explanation:**  
We mark the elements as follows:
- 1 is the smallest unmarked element, so we mark it and its two adjacent elements: [2,3,5,1,3,2].
- 2 is the smallest unmarked element, since there are two of them, we choose the left-most one: [2,3,5,1,3,2].
- Our score is 1 + 2 + 2 = **5**.

### Constraints:
- $`1 ≤ nums.length ≤ 10^5`$
- $`1 ≤ nums[i] ≤ 10^6`$

## 🎯 **My Approach:**

This problem can be tackled with a greedy approach, using a priority queue (min-heap) to efficiently pick the smallest unmarked element:

1. **Sorting and Tracking**: 
   - First, we store the indices of the elements along with their values in a min-heap. The heap ensures that we can quickly access the smallest unmarked element.
   
2. **Marking and Scoring**:
   - After picking an element, we mark it and its adjacent elements.
   - We keep track of the score by adding the chosen element's value.
   
3. **Efficient Execution**: 
   - By marking elements and using the heap to always choose the smallest element, we ensure that the algorithm runs in an efficient manner.

## 🕒 **Time Complexity:**
- **O(n log n)**:  
  Sorting the elements takes $O(n \log n)$ time, where $n$ is the number of elements in `nums`. Each operation on the priority queue (push and pop) also takes $O(\log n)$ time.

- **Space Complexity:**  
  **O(n)**: The space is used to store the min-heap and an array for marking the elements.

## 📝 **Solution Code**

## Code (C)

```c
typedef struct {
    int value;
    int index;
} Pair;

int compare(const void* a, const void* b) {
    Pair* p1 = (Pair*)a;
    Pair* p2 = (Pair*)b;
    if (p1->value == p2->value)
        return p1->index - p2->index;
    return p1->value - p2->value;
}

long long findScore(int* nums, int numsSize) {
    Pair* indexedNums = (Pair*)malloc(numsSize * sizeof(Pair));
    for (int i = 0; i < numsSize; i++) {
        indexedNums[i].value = nums[i];
        indexedNums[i].index = i;
    }

    qsort(indexedNums, numsSize, sizeof(Pair), compare);

    bool* vis = (bool*)calloc(numsSize, sizeof(bool));
    long long ans = 0;

    for (int i = 0; i < numsSize; i++) {
        int idx = indexedNums[i].index;
        if (!vis[idx]) {
            ans += indexedNums[i].value;
            vis[idx] = true;
            if (idx > 0) vis[idx - 1] = true;
            if (idx < numsSize - 1) vis[idx + 1] = true;
        }
    }

    free(indexedNums);
    free(vis);
    return ans;
}
```

## Code (C++)

```cpp
class Solution {
public:
    long long findScore(vector<int>& nums) {
        int n = nums.size();
        vector<pair<int, int>> indexedNums;

        for (int i = 0; i < n; i++) {
            indexedNums.emplace_back(nums[i], i);
        }
        
        sort(indexedNums.begin(), indexedNums.end());
        vector<bool> vis(n, false);
        long long ans = 0;

        for (auto& [val, idx] : indexedNums) {
            if (!vis[idx]) {
                ans += val;
                vis[idx] = true;
                if (idx > 0) vis[idx - 1] = true;
                if (idx < n - 1) vis[idx + 1] = true;
            }
        }

        return ans;
    }
};
```

## Code (Java)

```java
class Solution {
    public long findScore(int[] nums) {
        int n = nums.length;
        long ans = 0;
        boolean[] visited = new boolean[n];
        List<int[]> indexedNums = new ArrayList<>();

        for (int i = 0; i < n; i++) {
            indexedNums.add(new int[]{nums[i], i});
        }

        indexedNums.sort((a, b) -> a[0] == b[0] ? a[1] - b[1] : a[0] - b[0]);

        for (int[] pair : indexedNums) {
            int value = pair[0], idx = pair[1];
            if (!visited[idx]) {
                ans += value;
                visited[idx] = true;
                if (idx > 0) visited[idx - 1] = true;
                if (idx < n - 1) visited[idx + 1] = true;
            }
        }

        return ans;
    }
}
```

## Code (Python)

```python
class Solution:
    def findScore(self, nums: List[int]) -> int:
        n = len(nums)
        vis = [False] * n
        indexed_nums = sorted((x, i) for i, x in enumerate(nums))  
        ans = 0

        for x, i in indexed_nums:
            if not vis[i]: 
                ans += x
                vis[i] = True
                if i - 1 >= 0:  
                    vis[i - 1] = True
                if i + 1 < n: 
                    vis[i + 1] = True

        return ans
```

## Code (Rust)

```rust
impl Solution {
    pub fn find_score(nums: Vec<i32>) -> i64 {
        let n = nums.len();
        let mut indexed_nums: Vec<(i32, usize)> = nums.into_iter().enumerate().map(|(i, x)| (x, i)).collect();
        indexed_nums.sort_unstable();

        let mut vis = vec![false; n];
        let mut ans: i64 = 0;

        for (val, idx) in indexed_nums {
            if !vis[idx] {
                ans += val as i64;
                vis[idx] = true;
                if idx > 0 {
                    vis[idx - 1] = true;
                }
                if idx + 1 < n {
                    vis[idx + 1] = true;
                }
            }
        }

        ans
    }
}
```

## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
